package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Agreement;
import odata.msgraph.client.beta.entity.collection.request.AgreementAcceptanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AgreementFileLocalizationCollectionRequest;

@JsonIgnoreType
public class AgreementRequest extends EntityRequest<Agreement> {

    public AgreementRequest(ContextPath contextPath, Optional<Object> value) {
        super(Agreement.class, contextPath, value, false);
    }

    public AgreementAcceptanceRequest acceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("acceptances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementAcceptanceCollectionRequest acceptances() {
        return new AgreementAcceptanceCollectionRequest(
                        contextPath.addSegment("acceptances"), Optional.empty());
    }

    public AgreementFileRequest file() {
        return new AgreementFileRequest(contextPath.addSegment("file"), Optional.empty());
    }

    public AgreementFileLocalizationRequest files(String id) {
        return new AgreementFileLocalizationRequest(contextPath.addSegment("files").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementFileLocalizationCollectionRequest files() {
        return new AgreementFileLocalizationCollectionRequest(
                        contextPath.addSegment("files"), Optional.empty());
    }

}
