package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AgreementFile;
import odata.msgraph.client.beta.entity.collection.request.AgreementFileLocalizationCollectionRequest;

@JsonIgnoreType
public class AgreementFileRequest extends EntityRequest<AgreementFile> {

    public AgreementFileRequest(ContextPath contextPath, Optional<Object> value) {
        super(AgreementFile.class, contextPath, value, false);
    }

    public AgreementFileLocalizationRequest localizations(String id) {
        return new AgreementFileLocalizationRequest(contextPath.addSegment("localizations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AgreementFileLocalizationCollectionRequest localizations() {
        return new AgreementFileLocalizationCollectionRequest(
                        contextPath.addSegment("localizations"), Optional.empty());
    }

}
