package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewStage;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;

@JsonIgnoreType
public class AccessReviewStageRequest extends EntityRequest<AccessReviewStage> {

    public AccessReviewStageRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewStage.class, contextPath, value, false);
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.empty());
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

}
