package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewInstance;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewReviewerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewStageCollectionRequest;

@JsonIgnoreType
public class AccessReviewInstanceRequest extends EntityRequest<AccessReviewInstance> {

    public AccessReviewInstanceRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewInstance.class, contextPath, value, false);
    }

    public AccessReviewReviewerRequest contactedReviewers(String id) {
        return new AccessReviewReviewerRequest(contextPath.addSegment("contactedReviewers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewReviewerCollectionRequest contactedReviewers() {
        return new AccessReviewReviewerCollectionRequest(
                        contextPath.addSegment("contactedReviewers"), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemRequest decisions(String id) {
        return new AccessReviewInstanceDecisionItemRequest(contextPath.addSegment("decisions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewInstanceDecisionItemCollectionRequest decisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"), Optional.empty());
    }

    public AccessReviewScheduleDefinitionRequest definition() {
        return new AccessReviewScheduleDefinitionRequest(contextPath.addSegment("definition"), Optional.empty());
    }

    public AccessReviewStageRequest stages(String id) {
        return new AccessReviewStageRequest(contextPath.addSegment("stages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewStageCollectionRequest stages() {
        return new AccessReviewStageCollectionRequest(
                        contextPath.addSegment("stages"), Optional.empty());
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "acceptRecommendations")
    @JsonIgnore
    public ActionRequestNoReturn acceptRecommendations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acceptRecommendations"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Action(name = "batchRecordDecisions")
    @JsonIgnore
    public ActionRequestNoReturn batchRecordDecisions(String decision, String justification, String principalId, String resourceId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("decision", "Edm.String", Checks.checkIsAscii(decision))
            .put("justification", "Edm.String", Checks.checkIsAscii(justification))
            .put("principalId", "Edm.String", Checks.checkIsAscii(principalId))
            .put("resourceId", "Edm.String", Checks.checkIsAscii(resourceId))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.batchRecordDecisions"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

}
