package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.AccessReviewHistoryDefinition;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewHistoryInstanceCollectionRequest;

@JsonIgnoreType
public class AccessReviewHistoryDefinitionRequest extends EntityRequest<AccessReviewHistoryDefinition> {

    public AccessReviewHistoryDefinitionRequest(ContextPath contextPath, Optional<Object> value) {
        super(AccessReviewHistoryDefinition.class, contextPath, value, false);
    }

    public AccessReviewHistoryInstanceRequest instances(String id) {
        return new AccessReviewHistoryInstanceRequest(contextPath.addSegment("instances").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AccessReviewHistoryInstanceCollectionRequest instances() {
        return new AccessReviewHistoryInstanceCollectionRequest(
                        contextPath.addSegment("instances"), Optional.empty());
    }

}
