package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookWorksheet;
import odata.msgraph.client.beta.entity.request.WorkbookChartRequest;
import odata.msgraph.client.beta.entity.request.WorkbookNamedItemRequest;
import odata.msgraph.client.beta.entity.request.WorkbookPivotTableRequest;
import odata.msgraph.client.beta.entity.request.WorkbookTableRequest;
import odata.msgraph.client.beta.entity.request.WorkbookWorksheetRequest;

public class WorkbookWorksheetCollectionRequest extends CollectionPageEntityRequest<WorkbookWorksheet, WorkbookWorksheetRequest>{

    protected ContextPath contextPath;

    public WorkbookWorksheetCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookWorksheet.class, cp -> new WorkbookWorksheetRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookChartRequest charts(String id) {
        return new WorkbookChartRequest(contextPath.addSegment("charts").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookChartCollectionRequest charts() {
        return new WorkbookChartCollectionRequest(contextPath.addSegment("charts"), Optional.empty());
    }

    public WorkbookNamedItemRequest names(String id) {
        return new WorkbookNamedItemRequest(contextPath.addSegment("names").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookNamedItemCollectionRequest names() {
        return new WorkbookNamedItemCollectionRequest(contextPath.addSegment("names"), Optional.empty());
    }

    public WorkbookPivotTableRequest pivotTables(String id) {
        return new WorkbookPivotTableRequest(contextPath.addSegment("pivotTables").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookPivotTableCollectionRequest pivotTables() {
        return new WorkbookPivotTableCollectionRequest(contextPath.addSegment("pivotTables"), Optional.empty());
    }

    public WorkbookTableRequest tables(String id) {
        return new WorkbookTableRequest(contextPath.addSegment("tables").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookTableCollectionRequest tables() {
        return new WorkbookTableCollectionRequest(contextPath.addSegment("tables"), Optional.empty());
    }

    @Action(name = "add")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookWorksheet> add(String name) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookWorksheet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), WorkbookWorksheet.class, _parameters);
    }

}
