package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookPivotTable;
import odata.msgraph.client.beta.entity.request.WorkbookPivotTableRequest;

public class WorkbookPivotTableCollectionRequest extends CollectionPageEntityRequest<WorkbookPivotTable, WorkbookPivotTableRequest>{

    protected ContextPath contextPath;

    public WorkbookPivotTableCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookPivotTable.class, cp -> new WorkbookPivotTableRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "refreshAll")
    @JsonIgnore
    public ActionRequestNoReturn refreshAll() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshAll"), _parameters);
    }

}
