package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookComment;
import odata.msgraph.client.beta.entity.request.WorkbookCommentReplyRequest;
import odata.msgraph.client.beta.entity.request.WorkbookCommentRequest;

public class WorkbookCommentCollectionRequest extends CollectionPageEntityRequest<WorkbookComment, WorkbookCommentRequest>{

    protected ContextPath contextPath;

    public WorkbookCommentCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookComment.class, cp -> new WorkbookCommentRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookCommentReplyRequest replies(String id) {
        return new WorkbookCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookCommentReplyCollectionRequest replies() {
        return new WorkbookCommentReplyCollectionRequest(contextPath.addSegment("replies"), Optional.empty());
    }

}
