package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WorkbookChartSeries;
import odata.msgraph.client.beta.entity.request.WorkbookChartPointRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartSeriesRequest;

public class WorkbookChartSeriesCollectionRequest extends CollectionPageEntityRequest<WorkbookChartSeries, WorkbookChartSeriesRequest>{

    protected ContextPath contextPath;

    public WorkbookChartSeriesCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WorkbookChartSeries.class, cp -> new WorkbookChartSeriesRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkbookChartPointRequest points(String id) {
        return new WorkbookChartPointRequest(contextPath.addSegment("points").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WorkbookChartPointCollectionRequest points() {
        return new WorkbookChartPointCollectionRequest(contextPath.addSegment("points"), Optional.empty());
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters);
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartSeries> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartSeries>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookChartSeries.class, _parameters);
    }

}
