package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsQualityUpdateProfile;
import odata.msgraph.client.beta.entity.request.WindowsQualityUpdateProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsQualityUpdateProfileRequest;

public class WindowsQualityUpdateProfileCollectionRequest extends CollectionPageEntityRequest<WindowsQualityUpdateProfile, WindowsQualityUpdateProfileRequest>{

    protected ContextPath contextPath;

    public WindowsQualityUpdateProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WindowsQualityUpdateProfile.class, cp -> new WindowsQualityUpdateProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WindowsQualityUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsQualityUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsQualityUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsQualityUpdateProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
