package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsMalwareInformation;
import odata.msgraph.client.beta.entity.request.MalwareStateForWindowsDeviceRequest;
import odata.msgraph.client.beta.entity.request.WindowsMalwareInformationRequest;

public class WindowsMalwareInformationCollectionRequest extends CollectionPageEntityRequest<WindowsMalwareInformation, WindowsMalwareInformationRequest>{

    protected ContextPath contextPath;

    public WindowsMalwareInformationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WindowsMalwareInformation.class, cp -> new WindowsMalwareInformationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MalwareStateForWindowsDeviceRequest deviceMalwareStates(String id) {
        return new MalwareStateForWindowsDeviceRequest(contextPath.addSegment("deviceMalwareStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MalwareStateForWindowsDeviceCollectionRequest deviceMalwareStates() {
        return new MalwareStateForWindowsDeviceCollectionRequest(contextPath.addSegment("deviceMalwareStates"), Optional.empty());
    }

}
