package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsDriverUpdateProfile;
import odata.msgraph.client.beta.entity.request.WindowsDriverUpdateInventoryRequest;
import odata.msgraph.client.beta.entity.request.WindowsDriverUpdateProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsDriverUpdateProfileRequest;

public class WindowsDriverUpdateProfileCollectionRequest extends CollectionPageEntityRequest<WindowsDriverUpdateProfile, WindowsDriverUpdateProfileRequest>{

    protected ContextPath contextPath;

    public WindowsDriverUpdateProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WindowsDriverUpdateProfile.class, cp -> new WindowsDriverUpdateProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WindowsDriverUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsDriverUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDriverUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsDriverUpdateProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public WindowsDriverUpdateInventoryRequest driverInventories(String id) {
        return new WindowsDriverUpdateInventoryRequest(contextPath.addSegment("driverInventories").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDriverUpdateInventoryCollectionRequest driverInventories() {
        return new WindowsDriverUpdateInventoryCollectionRequest(contextPath.addSegment("driverInventories"), Optional.empty());
    }

}
