package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.WindowsDefenderApplicationControlSupplementalPolicy;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyRequest;

public class WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest extends CollectionPageEntityRequest<WindowsDefenderApplicationControlSupplementalPolicy, WindowsDefenderApplicationControlSupplementalPolicyRequest>{

    protected ContextPath contextPath;

    public WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, WindowsDefenderApplicationControlSupplementalPolicy.class, cp -> new WindowsDefenderApplicationControlSupplementalPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest assignments(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest assignments() {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest deviceStatuses(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest deviceStatuses() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

}
