package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.VppTokenLicenseSummary;
import odata.msgraph.client.beta.entity.VppToken;
import odata.msgraph.client.beta.entity.request.VppTokenRequest;

public class VppTokenCollectionRequest extends CollectionPageEntityRequest<VppToken, VppTokenRequest>{

    protected ContextPath contextPath;

    public VppTokenCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, VppToken.class, cp -> new VppTokenRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "syncLicenseCounts")
    @JsonIgnore
    public ActionRequestNoReturn syncLicenseCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncLicenseCounts"), _parameters);
    }

    @Function(name = "getLicensesForApp")
    @JsonIgnore
    public CollectionPageNonEntityRequest<VppTokenLicenseSummary> getLicensesForApp(String bundleId) {
        Preconditions.checkNotNull(bundleId, "bundleId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("bundleId", "Edm.String", Checks.checkIsAscii(bundleId))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getLicensesForApp"), VppTokenLicenseSummary.class, _parameters);
    }

}
