package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Vendor;
import odata.msgraph.client.beta.entity.request.PictureRequest;
import odata.msgraph.client.beta.entity.request.VendorRequest;

public class VendorCollectionRequest extends CollectionPageEntityRequest<Vendor, VendorRequest>{

    protected ContextPath contextPath;

    public VendorCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Vendor.class, cp -> new VendorRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"), Optional.empty());
    }

}
