package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserInstallStateSummary;
import odata.msgraph.client.beta.entity.request.DeviceInstallStateRequest;
import odata.msgraph.client.beta.entity.request.UserInstallStateSummaryRequest;

public class UserInstallStateSummaryCollectionRequest extends CollectionPageEntityRequest<UserInstallStateSummary, UserInstallStateSummaryRequest>{

    protected ContextPath contextPath;

    public UserInstallStateSummaryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserInstallStateSummary.class, cp -> new UserInstallStateSummaryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(contextPath.addSegment("deviceStates"), Optional.empty());
    }

}
