package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserFlowLanguageConfiguration;
import odata.msgraph.client.beta.entity.request.UserFlowLanguageConfigurationRequest;
import odata.msgraph.client.beta.entity.request.UserFlowLanguagePageRequest;

public class UserFlowLanguageConfigurationCollectionRequest extends CollectionPageEntityRequest<UserFlowLanguageConfiguration, UserFlowLanguageConfigurationRequest>{

    protected ContextPath contextPath;

    public UserFlowLanguageConfigurationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserFlowLanguageConfiguration.class, cp -> new UserFlowLanguageConfigurationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UserFlowLanguagePageRequest defaultPages(String id) {
        return new UserFlowLanguagePageRequest(contextPath.addSegment("defaultPages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguagePageCollectionRequest defaultPages() {
        return new UserFlowLanguagePageCollectionRequest(contextPath.addSegment("defaultPages"), Optional.empty());
    }

    public UserFlowLanguagePageRequest overridesPages(String id) {
        return new UserFlowLanguagePageRequest(contextPath.addSegment("overridesPages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserFlowLanguagePageCollectionRequest overridesPages() {
        return new UserFlowLanguagePageCollectionRequest(contextPath.addSegment("overridesPages"), Optional.empty());
    }

}
