package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsResourcePerformance;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsResourcePerformanceRequest;
import odata.msgraph.client.beta.enums.UserExperienceAnalyticsSummarizedBy;

public class UserExperienceAnalyticsResourcePerformanceCollectionRequest extends CollectionPageEntityRequest<UserExperienceAnalyticsResourcePerformance, UserExperienceAnalyticsResourcePerformanceRequest>{

    protected ContextPath contextPath;

    public UserExperienceAnalyticsResourcePerformanceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserExperienceAnalyticsResourcePerformance.class, cp -> new UserExperienceAnalyticsResourcePerformanceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "summarizeDeviceResourcePerformance")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UserExperienceAnalyticsResourcePerformance> summarizeDeviceResourcePerformance(UserExperienceAnalyticsSummarizedBy summarizeBy) {
        Preconditions.checkNotNull(summarizeBy, "summarizeBy cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("summarizeBy", "microsoft.graph.userExperienceAnalyticsSummarizedBy", summarizeBy)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.summarizeDeviceResourcePerformance"), UserExperienceAnalyticsResourcePerformance.class, _parameters);
    }

}
