package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsCategory;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsCategoryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsMetricRequest;

public class UserExperienceAnalyticsCategoryCollectionRequest extends CollectionPageEntityRequest<UserExperienceAnalyticsCategory, UserExperienceAnalyticsCategoryRequest>{

    protected ContextPath contextPath;

    public UserExperienceAnalyticsCategoryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserExperienceAnalyticsCategory.class, cp -> new UserExperienceAnalyticsCategoryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UserExperienceAnalyticsMetricRequest metricValues(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("metricValues").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserExperienceAnalyticsMetricCollectionRequest metricValues() {
        return new UserExperienceAnalyticsMetricCollectionRequest(contextPath.addSegment("metricValues"), Optional.empty());
    }

}
