package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserAppInstallStatus;
import odata.msgraph.client.beta.entity.request.MobileAppInstallStatusRequest;
import odata.msgraph.client.beta.entity.request.UserAppInstallStatusRequest;

public class UserAppInstallStatusCollectionRequest extends CollectionPageEntityRequest<UserAppInstallStatus, UserAppInstallStatusRequest>{

    protected ContextPath contextPath;

    public UserAppInstallStatusCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserAppInstallStatus.class, cp -> new UserAppInstallStatusRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(contextPath.addSegment("deviceStatuses"), Optional.empty());
    }

}
