package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UserActivity;
import odata.msgraph.client.beta.entity.request.ActivityHistoryItemRequest;
import odata.msgraph.client.beta.entity.request.UserActivityRequest;

public class UserActivityCollectionRequest extends CollectionPageEntityRequest<UserActivity, UserActivityRequest>{

    protected ContextPath contextPath;

    public UserActivityCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UserActivity.class, cp -> new UserActivityRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ActivityHistoryItemRequest historyItems(String id) {
        return new ActivityHistoryItemRequest(contextPath.addSegment("historyItems").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ActivityHistoryItemCollectionRequest historyItems() {
        return new ActivityHistoryItemCollectionRequest(contextPath.addSegment("historyItems"), Optional.empty());
    }

    @Function(name = "recent")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UserActivity> recent() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recent"), UserActivity.class, _parameters);
    }

}
