package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRoleEligibilitySchedule;
import odata.msgraph.client.beta.entity.request.UnifiedRoleEligibilityScheduleRequest;
import odata.msgraph.client.beta.enums.RoleEligibilityScheduleFilterByCurrentUserOptions;

public class UnifiedRoleEligibilityScheduleCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleEligibilitySchedule, UnifiedRoleEligibilityScheduleRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleEligibilityScheduleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRoleEligibilitySchedule.class, cp -> new UnifiedRoleEligibilityScheduleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Function(name = "filterByCurrentUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UnifiedRoleEligibilitySchedule> filterByCurrentUser(RoleEligibilityScheduleFilterByCurrentUserOptions on) {
        Preconditions.checkNotNull(on, "on cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("on", "microsoft.graph.roleEligibilityScheduleFilterByCurrentUserOptions", on)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.filterByCurrentUser"), UnifiedRoleEligibilitySchedule.class, _parameters);
    }

}
