package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.UnifiedRbacResourceNamespace;
import odata.msgraph.client.beta.entity.request.UnifiedRbacResourceActionRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRbacResourceNamespaceRequest;

public class UnifiedRbacResourceNamespaceCollectionRequest extends CollectionPageEntityRequest<UnifiedRbacResourceNamespace, UnifiedRbacResourceNamespaceRequest>{

    protected ContextPath contextPath;

    public UnifiedRbacResourceNamespaceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, UnifiedRbacResourceNamespace.class, cp -> new UnifiedRbacResourceNamespaceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public UnifiedRbacResourceActionRequest resourceActions(String id) {
        return new UnifiedRbacResourceActionRequest(contextPath.addSegment("resourceActions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UnifiedRbacResourceActionCollectionRequest resourceActions() {
        return new UnifiedRbacResourceActionCollectionRequest(contextPath.addSegment("resourceActions"), Optional.empty());
    }

}
