package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TodoTaskList;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.TodoTaskListRequest;
import odata.msgraph.client.beta.entity.request.TodoTaskRequest;

public class TodoTaskListCollectionRequest extends CollectionPageEntityRequest<TodoTaskList, TodoTaskListRequest>{

    protected ContextPath contextPath;

    public TodoTaskListCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TodoTaskList.class, cp -> new TodoTaskListRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    public TodoTaskRequest tasks(String id) {
        return new TodoTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TodoTaskCollectionRequest tasks() {
        return new TodoTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TodoTaskList> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), TodoTaskList.class, _parameters);
    }

}
