package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TodoTask;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.LinkedResourceRequest;
import odata.msgraph.client.beta.entity.request.TodoTaskRequest;

public class TodoTaskCollectionRequest extends CollectionPageEntityRequest<TodoTask, TodoTaskRequest>{

    protected ContextPath contextPath;

    public TodoTaskCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TodoTask.class, cp -> new TodoTaskRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

    public LinkedResourceRequest linkedResources(String id) {
        return new LinkedResourceRequest(contextPath.addSegment("linkedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public LinkedResourceCollectionRequest linkedResources() {
        return new LinkedResourceCollectionRequest(contextPath.addSegment("linkedResources"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TodoTask> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), TodoTask.class, _parameters);
    }

}
