package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ThreatAssessmentRequest;
import odata.msgraph.client.beta.entity.request.ThreatAssessmentRequestRequest;
import odata.msgraph.client.beta.entity.request.ThreatAssessmentResultRequest;

public class ThreatAssessmentRequestCollectionRequest extends CollectionPageEntityRequest<ThreatAssessmentRequest, ThreatAssessmentRequestRequest>{

    protected ContextPath contextPath;

    public ThreatAssessmentRequestCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ThreatAssessmentRequest.class, cp -> new ThreatAssessmentRequestRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ThreatAssessmentResultRequest results(String id) {
        return new ThreatAssessmentResultRequest(contextPath.addSegment("results").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ThreatAssessmentResultCollectionRequest results() {
        return new ThreatAssessmentResultCollectionRequest(contextPath.addSegment("results"), Optional.empty());
    }

}
