package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.TermsAndConditions;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsAcceptanceStatusRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsAssignmentRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsRequest;

public class TermsAndConditionsCollectionRequest extends CollectionPageEntityRequest<TermsAndConditions, TermsAndConditionsRequest>{

    protected ContextPath contextPath;

    public TermsAndConditionsCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, TermsAndConditions.class, cp -> new TermsAndConditionsRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TermsAndConditionsAcceptanceStatusRequest acceptanceStatuses(String id) {
        return new TermsAndConditionsAcceptanceStatusRequest(contextPath.addSegment("acceptanceStatuses").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsAcceptanceStatusCollectionRequest acceptanceStatuses() {
        return new TermsAndConditionsAcceptanceStatusCollectionRequest(contextPath.addSegment("acceptanceStatuses"), Optional.empty());
    }

    public TermsAndConditionsAssignmentRequest assignments(String id) {
        return new TermsAndConditionsAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsAssignmentCollectionRequest assignments() {
        return new TermsAndConditionsAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    public TermsAndConditionsGroupAssignmentRequest groupAssignments(String id) {
        return new TermsAndConditionsGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TermsAndConditionsGroupAssignmentCollectionRequest groupAssignments() {
        return new TermsAndConditionsGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"), Optional.empty());
    }

}
