package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SubjectRightsRequest;
import odata.msgraph.client.beta.entity.request.AuthoredNoteRequest;
import odata.msgraph.client.beta.entity.request.SubjectRightsRequestRequest;

public class SubjectRightsRequestCollectionRequest extends CollectionPageEntityRequest<SubjectRightsRequest, SubjectRightsRequestRequest>{

    protected ContextPath contextPath;

    public SubjectRightsRequestCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SubjectRightsRequest.class, cp -> new SubjectRightsRequestRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AuthoredNoteRequest notes(String id) {
        return new AuthoredNoteRequest(contextPath.addSegment("notes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public AuthoredNoteCollectionRequest notes() {
        return new AuthoredNoteCollectionRequest(contextPath.addSegment("notes"), Optional.empty());
    }

}
