package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Site;
import odata.msgraph.client.beta.entity.request.BaseItemRequest;
import odata.msgraph.client.beta.entity.request.ColumnDefinitionRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.ListRequest;
import odata.msgraph.client.beta.entity.request.PermissionRequest;
import odata.msgraph.client.beta.entity.request.RichLongRunningOperationRequest;
import odata.msgraph.client.beta.entity.request.SitePageRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;

public class SiteCollectionRequest extends CollectionPageEntityRequest<Site, SiteRequest>{

    protected ContextPath contextPath;

    public SiteCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Site.class, cp -> new SiteRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columns"), Optional.empty());
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(contextPath.addSegment("contentTypes"), Optional.empty());
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(contextPath.addSegment("drives"), Optional.empty());
    }

    public ColumnDefinitionRequest externalColumns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("externalColumns").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ColumnDefinitionCollectionRequest externalColumns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("externalColumns"), Optional.empty());
    }

    public BaseItemRequest items(String id) {
        return new BaseItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public BaseItemCollectionRequest items() {
        return new BaseItemCollectionRequest(contextPath.addSegment("items"), Optional.empty());
    }

    public ListRequest lists(String id) {
        return new ListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ListCollectionRequest lists() {
        return new ListCollectionRequest(contextPath.addSegment("lists"), Optional.empty());
    }

    public RichLongRunningOperationRequest operations(String id) {
        return new RichLongRunningOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RichLongRunningOperationCollectionRequest operations() {
        return new RichLongRunningOperationCollectionRequest(contextPath.addSegment("operations"), Optional.empty());
    }

    public SitePageRequest pages(String id) {
        return new SitePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SitePageCollectionRequest pages() {
        return new SitePageCollectionRequest(contextPath.addSegment("pages"), Optional.empty());
    }

    public PermissionRequest permissions(String id) {
        return new PermissionRequest(contextPath.addSegment("permissions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PermissionCollectionRequest permissions() {
        return new PermissionCollectionRequest(contextPath.addSegment("permissions"), Optional.empty());
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(contextPath.addSegment("sites"), Optional.empty());
    }

    @Action(name = "add")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> add(List<Site> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.site)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), Site.class, _parameters);
    }

    @Action(name = "remove")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> remove(List<Site> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.site)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remove"), Site.class, _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Site.class, _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> delta_Function(String token) {
        Preconditions.checkNotNull(token, "token cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("token", "Edm.String", Checks.checkIsAscii(token))
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), Site.class, _parameters);
    }

}
