package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServiceUpdateMessage;
import odata.msgraph.client.beta.entity.request.ServiceAnnouncementAttachmentRequest;
import odata.msgraph.client.beta.entity.request.ServiceUpdateMessageRequest;

public class ServiceUpdateMessageCollectionRequest extends CollectionPageEntityRequest<ServiceUpdateMessage, ServiceUpdateMessageRequest>{

    protected ContextPath contextPath;

    public ServiceUpdateMessageCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ServiceUpdateMessage.class, cp -> new ServiceUpdateMessageRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ServiceAnnouncementAttachmentRequest attachments(String id) {
        return new ServiceAnnouncementAttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServiceAnnouncementAttachmentCollectionRequest attachments() {
        return new ServiceAnnouncementAttachmentCollectionRequest(contextPath.addSegment("attachments"), Optional.empty());
    }

    @Action(name = "archive")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> archive(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.archive"), Boolean.class, _parameters);
    }

    @Action(name = "favorite")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> favorite(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.favorite"), Boolean.class, _parameters);
    }

    @Action(name = "markRead")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> markRead(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markRead"), Boolean.class, _parameters);
    }

    @Action(name = "markUnread")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> markUnread(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.markUnread"), Boolean.class, _parameters);
    }

    @Action(name = "unarchive")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> unarchive(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unarchive"), Boolean.class, _parameters);
    }

    @Action(name = "unfavorite")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> unfavorite(List<String> messageIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("messageIds", "Collection(Edm.String)", Checks.checkIsAscii(messageIds))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unfavorite"), Boolean.class, _parameters);
    }

}
