package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.ServicePrincipalCreationPolicy;
import odata.msgraph.client.beta.entity.request.ServicePrincipalCreationConditionSetRequest;
import odata.msgraph.client.beta.entity.request.ServicePrincipalCreationPolicyRequest;

public class ServicePrincipalCreationPolicyCollectionRequest extends CollectionPageEntityRequest<ServicePrincipalCreationPolicy, ServicePrincipalCreationPolicyRequest>{

    protected ContextPath contextPath;

    public ServicePrincipalCreationPolicyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, ServicePrincipalCreationPolicy.class, cp -> new ServicePrincipalCreationPolicyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ServicePrincipalCreationConditionSetRequest excludes(String id) {
        return new ServicePrincipalCreationConditionSetRequest(contextPath.addSegment("excludes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetCollectionRequest excludes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(contextPath.addSegment("excludes"), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetRequest includes(String id) {
        return new ServicePrincipalCreationConditionSetRequest(contextPath.addSegment("includes").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ServicePrincipalCreationConditionSetCollectionRequest includes() {
        return new ServicePrincipalCreationConditionSetCollectionRequest(contextPath.addSegment("includes"), Optional.empty());
    }

}
