package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesQuote;
import odata.msgraph.client.beta.entity.request.SalesQuoteLineRequest;
import odata.msgraph.client.beta.entity.request.SalesQuoteRequest;

public class SalesQuoteCollectionRequest extends CollectionPageEntityRequest<SalesQuote, SalesQuoteRequest>{

    protected ContextPath contextPath;

    public SalesQuoteCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SalesQuote.class, cp -> new SalesQuoteRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SalesQuoteLineRequest salesQuoteLines(String id) {
        return new SalesQuoteLineRequest(contextPath.addSegment("salesQuoteLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesQuoteLineCollectionRequest salesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(contextPath.addSegment("salesQuoteLines"), Optional.empty());
    }

}
