package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesOrder;
import odata.msgraph.client.beta.entity.request.SalesOrderLineRequest;
import odata.msgraph.client.beta.entity.request.SalesOrderRequest;

public class SalesOrderCollectionRequest extends CollectionPageEntityRequest<SalesOrder, SalesOrderRequest>{

    protected ContextPath contextPath;

    public SalesOrderCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SalesOrder.class, cp -> new SalesOrderRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SalesOrderLineRequest salesOrderLines(String id) {
        return new SalesOrderLineRequest(contextPath.addSegment("salesOrderLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesOrderLineCollectionRequest salesOrderLines() {
        return new SalesOrderLineCollectionRequest(contextPath.addSegment("salesOrderLines"), Optional.empty());
    }

}
