package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesInvoice;
import odata.msgraph.client.beta.entity.request.SalesInvoiceLineRequest;
import odata.msgraph.client.beta.entity.request.SalesInvoiceRequest;

public class SalesInvoiceCollectionRequest extends CollectionPageEntityRequest<SalesInvoice, SalesInvoiceRequest>{

    protected ContextPath contextPath;

    public SalesInvoiceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SalesInvoice.class, cp -> new SalesInvoiceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SalesInvoiceLineRequest salesInvoiceLines(String id) {
        return new SalesInvoiceLineRequest(contextPath.addSegment("salesInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesInvoiceLineCollectionRequest salesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(contextPath.addSegment("salesInvoiceLines"), Optional.empty());
    }

}
