package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.SalesCreditMemo;
import odata.msgraph.client.beta.entity.request.SalesCreditMemoLineRequest;
import odata.msgraph.client.beta.entity.request.SalesCreditMemoRequest;

public class SalesCreditMemoCollectionRequest extends CollectionPageEntityRequest<SalesCreditMemo, SalesCreditMemoRequest>{

    protected ContextPath contextPath;

    public SalesCreditMemoCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, SalesCreditMemo.class, cp -> new SalesCreditMemoRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SalesCreditMemoLineRequest salesCreditMemoLines(String id) {
        return new SalesCreditMemoLineRequest(contextPath.addSegment("salesCreditMemoLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public SalesCreditMemoLineCollectionRequest salesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(contextPath.addSegment("salesCreditMemoLines"), Optional.empty());
    }

}
