package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RoleScopeTag;
import odata.msgraph.client.beta.entity.request.RoleScopeTagAutoAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleScopeTagRequest;

public class RoleScopeTagCollectionRequest extends CollectionPageEntityRequest<RoleScopeTag, RoleScopeTagRequest>{

    protected ContextPath contextPath;

    public RoleScopeTagCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, RoleScopeTag.class, cp -> new RoleScopeTagRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RoleScopeTagAutoAssignmentRequest assignments(String id) {
        return new RoleScopeTagAutoAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RoleScopeTagAutoAssignmentCollectionRequest assignments() {
        return new RoleScopeTagAutoAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

    @Action(name = "getRoleScopeTagsById")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsById(List<String> roleScopeTagIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("roleScopeTagIds", "Collection(Edm.String)", Checks.checkIsAscii(roleScopeTagIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsById"), RoleScopeTag.class, _parameters);
    }

    @Function(name = "hasCustomRoleScopeTag")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> hasCustomRoleScopeTag() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasCustomRoleScopeTag"), Boolean.class, _parameters);
    }

}
