package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.RiskyServicePrincipal;
import odata.msgraph.client.beta.entity.request.RiskyServicePrincipalHistoryItemRequest;
import odata.msgraph.client.beta.entity.request.RiskyServicePrincipalRequest;

public class RiskyServicePrincipalCollectionRequest extends CollectionPageEntityRequest<RiskyServicePrincipal, RiskyServicePrincipalRequest>{

    protected ContextPath contextPath;

    public RiskyServicePrincipalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, RiskyServicePrincipal.class, cp -> new RiskyServicePrincipalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RiskyServicePrincipalHistoryItemRequest history(String id) {
        return new RiskyServicePrincipalHistoryItemRequest(contextPath.addSegment("history").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RiskyServicePrincipalHistoryItemCollectionRequest history() {
        return new RiskyServicePrincipalHistoryItemCollectionRequest(contextPath.addSegment("history"), Optional.empty());
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestNoReturn dismiss(List<String> servicePrincipalIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("servicePrincipalIds", "Collection(Edm.String)", Checks.checkIsAscii(servicePrincipalIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), _parameters);
    }

    @Action(name = "confirmCompromised")
    @JsonIgnore
    public ActionRequestNoReturn confirmCompromised(List<String> servicePrincipalIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("servicePrincipalIds", "Collection(Edm.String)", Checks.checkIsAscii(servicePrincipalIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confirmCompromised"), _parameters);
    }

}
