package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Recommendation;
import odata.msgraph.client.beta.entity.request.RecommendationRequest;
import odata.msgraph.client.beta.entity.request.RecommendationResourceRequest;

public class RecommendationCollectionRequest extends CollectionPageEntityRequest<Recommendation, RecommendationRequest>{

    protected ContextPath contextPath;

    public RecommendationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Recommendation.class, cp -> new RecommendationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public RecommendationResourceRequest impactedResources(String id) {
        return new RecommendationResourceRequest(contextPath.addSegment("impactedResources").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public RecommendationResourceCollectionRequest impactedResources() {
        return new RecommendationResourceCollectionRequest(contextPath.addSegment("impactedResources"), Optional.empty());
    }

}
