package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PurchaseInvoice;
import odata.msgraph.client.beta.entity.request.PurchaseInvoiceLineRequest;
import odata.msgraph.client.beta.entity.request.PurchaseInvoiceRequest;

public class PurchaseInvoiceCollectionRequest extends CollectionPageEntityRequest<PurchaseInvoice, PurchaseInvoiceRequest>{

    protected ContextPath contextPath;

    public PurchaseInvoiceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PurchaseInvoice.class, cp -> new PurchaseInvoiceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PurchaseInvoiceLineRequest purchaseInvoiceLines(String id) {
        return new PurchaseInvoiceLineRequest(contextPath.addSegment("purchaseInvoiceLines").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PurchaseInvoiceLineCollectionRequest purchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(contextPath.addSegment("purchaseInvoiceLines"), Optional.empty());
    }

}
