package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RoleSuccessStatistics;
import odata.msgraph.client.beta.entity.PrivilegedSignupStatus;
import odata.msgraph.client.beta.entity.TenantSetupInfo;
import odata.msgraph.client.beta.entity.request.PrivilegedSignupStatusRequest;

public class PrivilegedSignupStatusCollectionRequest extends CollectionPageEntityRequest<PrivilegedSignupStatus, PrivilegedSignupStatusRequest>{

    protected ContextPath contextPath;

    public PrivilegedSignupStatusCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrivilegedSignupStatus.class, cp -> new PrivilegedSignupStatusRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    @Action(name = "completeSetup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleSuccessStatistics> completeSetup(TenantSetupInfo tenantSetupInfo) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tenantSetupInfo", "microsoft.graph.tenantSetupInfo", tenantSetupInfo)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeSetup"), RoleSuccessStatistics.class, _parameters);
    }

    @Action(name = "signUp")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedSignupStatus> signUp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedSignupStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.signUp"), PrivilegedSignupStatus.class, _parameters);
    }

    @Function(name = "canSignUp")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> canSignUp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.canSignUp"), Boolean.class, _parameters);
    }

    @Function(name = "isSignedUp")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isSignedUp() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isSignedUp"), Boolean.class, _parameters);
    }

}
