package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrivilegedRole;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;

public class PrivilegedRoleCollectionRequest extends CollectionPageEntityRequest<PrivilegedRole, PrivilegedRoleRequest>{

    protected ContextPath contextPath;

    public PrivilegedRoleCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrivilegedRole.class, cp -> new PrivilegedRoleRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrivilegedRoleAssignmentRequest assignments(String id) {
        return new PrivilegedRoleAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrivilegedRoleAssignmentCollectionRequest assignments() {
        return new PrivilegedRoleAssignmentCollectionRequest(contextPath.addSegment("assignments"), Optional.empty());
    }

}
