package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrinterShare;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.PrinterShareRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;

public class PrinterShareCollectionRequest extends CollectionPageEntityRequest<PrinterShare, PrinterShareRequest>{

    protected ContextPath contextPath;

    public PrinterShareCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrinterShare.class, cp -> new PrinterShareRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GroupRequest allowedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public GroupCollectionRequest allowedGroups() {
        return new GroupCollectionRequest(contextPath.addSegment("allowedGroups"), Optional.empty());
    }

    public UserRequest allowedUsers(String id) {
        return new UserRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public UserCollectionRequest allowedUsers() {
        return new UserCollectionRequest(contextPath.addSegment("allowedUsers"), Optional.empty());
    }

}
