package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrintService;
import odata.msgraph.client.beta.entity.request.PrintServiceEndpointRequest;
import odata.msgraph.client.beta.entity.request.PrintServiceRequest;

public class PrintServiceCollectionRequest extends CollectionPageEntityRequest<PrintService, PrintServiceRequest>{

    protected ContextPath contextPath;

    public PrintServiceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrintService.class, cp -> new PrintServiceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrintServiceEndpointRequest endpoints(String id) {
        return new PrintServiceEndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintServiceEndpointCollectionRequest endpoints() {
        return new PrintServiceEndpointCollectionRequest(contextPath.addSegment("endpoints"), Optional.empty());
    }

}
