package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PrintJob;
import odata.msgraph.client.beta.entity.request.PrintDocumentRequest;
import odata.msgraph.client.beta.entity.request.PrintJobRequest;
import odata.msgraph.client.beta.entity.request.PrintTaskRequest;

public class PrintJobCollectionRequest extends CollectionPageEntityRequest<PrintJob, PrintJobRequest>{

    protected ContextPath contextPath;

    public PrintJobCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PrintJob.class, cp -> new PrintJobRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrintDocumentRequest documents(String id) {
        return new PrintDocumentRequest(contextPath.addSegment("documents").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintDocumentCollectionRequest documents() {
        return new PrintDocumentCollectionRequest(contextPath.addSegment("documents"), Optional.empty());
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(contextPath.addSegment("tasks"), Optional.empty());
    }

}
