package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.PlannerRoster;
import odata.msgraph.client.beta.entity.request.PlannerPlanRequest;
import odata.msgraph.client.beta.entity.request.PlannerRosterMemberRequest;
import odata.msgraph.client.beta.entity.request.PlannerRosterRequest;

public class PlannerRosterCollectionRequest extends CollectionPageEntityRequest<PlannerRoster, PlannerRosterRequest>{

    protected ContextPath contextPath;

    public PlannerRosterCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, PlannerRoster.class, cp -> new PlannerRosterRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PlannerRosterMemberRequest members(String id) {
        return new PlannerRosterMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerRosterMemberCollectionRequest members() {
        return new PlannerRosterMemberCollectionRequest(contextPath.addSegment("members"), Optional.empty());
    }

    public PlannerPlanRequest plans(String id) {
        return new PlannerPlanRequest(contextPath.addSegment("plans").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public PlannerPlanCollectionRequest plans() {
        return new PlannerPlanCollectionRequest(contextPath.addSegment("plans"), Optional.empty());
    }

}
