package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutlookTaskGroup;
import odata.msgraph.client.beta.entity.request.OutlookTaskFolderRequest;
import odata.msgraph.client.beta.entity.request.OutlookTaskGroupRequest;

public class OutlookTaskGroupCollectionRequest extends CollectionPageEntityRequest<OutlookTaskGroup, OutlookTaskGroupRequest>{

    protected ContextPath contextPath;

    public OutlookTaskGroupCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OutlookTaskGroup.class, cp -> new OutlookTaskGroupRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OutlookTaskFolderRequest taskFolders(String id) {
        return new OutlookTaskFolderRequest(contextPath.addSegment("taskFolders").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public OutlookTaskFolderCollectionRequest taskFolders() {
        return new OutlookTaskFolderCollectionRequest(contextPath.addSegment("taskFolders"), Optional.empty());
    }

}
