package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OutboundSharedUserProfile;
import odata.msgraph.client.beta.entity.request.OutboundSharedUserProfileRequest;
import odata.msgraph.client.beta.entity.request.TenantReferenceRequest;

public class OutboundSharedUserProfileCollectionRequest extends CollectionPageEntityRequest<OutboundSharedUserProfile, OutboundSharedUserProfileRequest>{

    protected ContextPath contextPath;

    public OutboundSharedUserProfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OutboundSharedUserProfile.class, cp -> new OutboundSharedUserProfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TenantReferenceRequest tenants(String id) {
        return new TenantReferenceRequest(contextPath.addSegment("tenants").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public TenantReferenceCollectionRequest tenants() {
        return new TenantReferenceCollectionRequest(contextPath.addSegment("tenants"), Optional.empty());
    }

}
