package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import odata.msgraph.client.beta.entity.Organization;
import odata.msgraph.client.beta.entity.request.CertificateBasedAuthConfigurationRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.OrganizationRequest;

public class OrganizationCollectionRequest extends CollectionPageEntityRequest<Organization, OrganizationRequest>{

    protected ContextPath contextPath;

    public OrganizationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Organization.class, cp -> new OrganizationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public CertificateBasedAuthConfigurationRequest certificateBasedAuthConfiguration(String id) {
        return new CertificateBasedAuthConfigurationRequest(contextPath.addSegment("certificateBasedAuthConfiguration").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public CertificateBasedAuthConfigurationCollectionRequest certificateBasedAuthConfiguration() {
        return new CertificateBasedAuthConfigurationCollectionRequest(contextPath.addSegment("certificateBasedAuthConfiguration"), Optional.empty());
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"), Optional.empty());
    }

}
