package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.OrgContact;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.OrgContactRequest;

public class OrgContactCollectionRequest extends CollectionPageEntityRequest<OrgContact, OrgContactRequest>{

    protected ContextPath contextPath;

    public OrgContactCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OrgContact.class, cp -> new OrgContactRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directReports"), Optional.empty());
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"), Optional.empty());
    }

    public DirectoryObjectRequest transitiveReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public DirectoryObjectCollectionRequest transitiveReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveReports"), Optional.empty());
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OrgContact> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), OrgContact.class, _parameters);
    }

}
