package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ChatInfo;
import odata.msgraph.client.beta.complex.MeetingParticipants;
import odata.msgraph.client.beta.entity.OnlineMeeting;
import odata.msgraph.client.beta.entity.request.MeetingAttendanceReportRequest;
import odata.msgraph.client.beta.entity.request.OnlineMeetingRequest;

public class OnlineMeetingCollectionRequest extends CollectionPageEntityRequest<OnlineMeeting, OnlineMeetingRequest>{

    protected ContextPath contextPath;

    public OnlineMeetingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, OnlineMeeting.class, cp -> new OnlineMeetingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MeetingAttendanceReportRequest attendanceReports(String id) {
        return new MeetingAttendanceReportRequest(contextPath.addSegment("attendanceReports").addKeys(new NameValue(id, String.class)), Optional.empty());
    }

    public MeetingAttendanceReportCollectionRequest attendanceReports() {
        return new MeetingAttendanceReportCollectionRequest(contextPath.addSegment("attendanceReports"), Optional.empty());
    }

    @Action(name = "createOrGet")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<OnlineMeeting> createOrGet(ChatInfo chatInfo, OffsetDateTime endDateTime, String externalId, MeetingParticipants participants, OffsetDateTime startDateTime, String subject) {
        Preconditions.checkNotNull(externalId, "externalId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("chatInfo", "microsoft.graph.chatInfo", chatInfo)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .put("externalId", "Edm.String", Checks.checkIsAscii(externalId))
            .put("participants", "microsoft.graph.meetingParticipants", participants)
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("subject", "Edm.String", Checks.checkIsAscii(subject))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<OnlineMeeting>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createOrGet"), OnlineMeeting.class, _parameters);
    }

}
